/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.reminder;

import de.willuhn.jameica.reminder.Reminder;
import de.willuhn.jameica.reminder.ReminderInterval;
import de.willuhn.jameica.reminder.ReminderStorageProvider;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractReminderStorageProvider
implements ReminderStorageProvider {
    protected String createUUID() {
        return UUID.randomUUID().toString();
    }

    @Override
    public Map<String, Reminder> find(String queue, Date from, Date to) throws Exception {
        String[] uuids;
        boolean haveQueue = StringUtils.trimToNull((String)queue) != null;
        HashMap<String, Reminder> map = new HashMap<String, Reminder>();
        for (String uuid : uuids = this.getUUIDs()) {
            Reminder r = this.get(uuid);
            String rq = StringUtils.trimToEmpty((String)r.getQueue());
            if (haveQueue && !queue.equals(rq)) continue;
            Date d = r.getDate();
            if (to != null && d.after(to)) continue;
            ReminderInterval ri = r.getReminderInterval();
            if (ri == null) {
                if (from != null && !d.after(from) && !d.equals(from)) continue;
                map.put(uuid, r);
                continue;
            }
            List<Date> dates = ri.getDates(d, from, to);
            if (dates.size() <= 0) continue;
            map.put(uuid, r);
        }
        return map;
    }
}

